/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.atlassian.aws.s3.S3UtilsThin;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class EtagCalculator {
    private static final long DEFAULT_MULTIPART_UPLOAD_THRESHOLD = 0x1000000L;
    private static final long DEFAULT_MINIMUM_UPLOAD_PART_SIZE = 0x500000L;
    private static final long DEFAULT_MULTIPART_COPY_THRESHOLD = 0x140000000L;
    private static final long DEFAULT_MINIMUM_COPY_PART_SIZE = 0x6400000L;
    private final long multipartUploadThreshold;
    private final long minimumUploadPartSize;

    public EtagCalculator(long multipartUploadThreshold, long minimumUploadPartSize) {
        this.multipartUploadThreshold = multipartUploadThreshold;
        this.minimumUploadPartSize = minimumUploadPartSize;
    }

    public String calculateEtag(@NotNull File file) throws IOException {
        return S3UtilsThin.calculateEtag(file, this.multipartUploadThreshold, this.minimumUploadPartSize);
    }

    public static EtagCalculator forTransferManager(TransferManager transferManager) {
        TransferManagerConfiguration configuration = transferManager.getConfiguration();
        return new EtagCalculator(configuration.getMultipartUploadThreshold(), configuration.getMinimumUploadPartSize());
    }

    public static TransferManager newCompatibleTransferManager(AmazonS3 s3Client) {
        TransferManager transferManager = new TransferManager(s3Client);
        TransferManagerConfiguration configuration = transferManager.getConfiguration();
        configuration.setMultipartUploadThreshold(0x1000000L);
        configuration.setMinimumUploadPartSize(0x500000L);
        configuration.setMultipartCopyThreshold(0x140000000L);
        configuration.setMultipartCopyPartSize(0x6400000L);
        return transferManager;
    }
}

