package com.atlassian.aws.ec2;

import com.amazonaws.util.EC2MetadataUtils;

import java.io.IOException;

class LocalEC2InstanceImpl implements EC2Instance
{
    private String instanceId;

    @Override
    public synchronized String getInstanceId() throws IOException
    {
        if (instanceId==null)
        {
            instanceId = fetchInstanceId();
        }
        return instanceId;
    }

    private String fetchInstanceId()
    {
        return EC2MetadataUtils.getInstanceId();
    }
}
