/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.utils;

import com.atlassian.aws.utils.CompressionUtils;
import com.atlassian.aws.utils.URLFetcher;
import com.atlassian.aws.utils.URLFetcherImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.nio.charset.Charset;

public class URLFetcherUtils {
    private static volatile URLFetcher urlFetcher = new URLFetcherImpl();

    private URLFetcherUtils() {
    }

    public static URLFetcher getURLFetcher() {
        return urlFetcher;
    }

    public static void setURLFetcher(URLFetcher urlFetcher) {
        URLFetcherUtils.urlFetcher = urlFetcher;
    }

    public static String fetchString(String userDataUrl, Charset charset, boolean shouldAttemptDecompression) throws IOException {
        return new String(URLFetcherUtils.fetchData(userDataUrl, shouldAttemptDecompression), charset);
    }

    private static byte[] fetchData(String userDataUrl, boolean shouldAttemptDecompression) throws IOException {
        byte[] data;
        try {
            data = URLFetcherUtils.getURLFetcher().fetchData(userDataUrl);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("This program must be run within an EC2 instance started from Bamboo: " + e);
        }
        catch (NoRouteToHostException e) {
            throw new NoRouteToHostException("Unable to access instance metadata. This program must be run within an EC2 instance: " + e);
        }
        return shouldAttemptDecompression ? CompressionUtils.decompress(data) : data;
    }
}

