package com.atlassian.aws.utils;

import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.net.URL;

/**
 * <p>An interface for fetching data from {@link URL}s.</p>
 */
public interface URLFetcher
{
    /**
     * <p>Fetches a {@link String} from the given {@link URL}.</p>
     *
     * @param url   The URL from which to fetch the String.
     * @return  The fetched String.
     * @throws IOException  If there was a problem fetching the String.
     */
    @NotNull
    String fetchString(String url)
            throws IOException;

    /**
     * <p>Fetches bytes from the given {@link URL}.</p>
     *
     * @param url   The URL from which to fetch the data.
     * @return  The fetched String.
     * @throws IOException  If there was a problem fetching the String.
     */
    @NotNull
    byte[] fetchData(String url)
            throws IOException;

}
