package com.atlassian.aws;

import com.amazonaws.ClientConfiguration;

/**
 * @deprecated
 */
@Deprecated
public class HttpClientConfigurationUtilsDoNotUse
{
    private static final String HTTPS = "https";
    private static final String HTTP = "http";

    private HttpClientConfigurationUtilsDoNotUse()
    {
    }

    public static ClientConfiguration newClientConfiguration(final int transmissionTimeoutMs, final int maxRetries)
    {
        final ClientConfiguration clientConfiguration = new ClientConfiguration();
        applyTimeoutSettings(clientConfiguration, transmissionTimeoutMs, maxRetries);
        applyProxyProperties(clientConfiguration);
        return clientConfiguration;
    }

    public static ClientConfiguration applyTimeoutSettings(final ClientConfiguration clientConfiguration, final int timeoutMs, final int maxRetries)
    {
        return clientConfiguration
                .withSocketTimeout(timeoutMs)
                .withConnectionTimeout(timeoutMs)
                .withMaxErrorRetry(maxRetries);
    }

    public static ClientConfiguration applyProxyProperties(final ClientConfiguration clientConfiguration)
    {
        // Set proxy host and proxy port if system properties indicate that we are sending outgoing requests through
        // a proxy.
        // First try to apply https proxy settings,  if https proxy settings are not defined, try http
        if (!applyProxyProperties(clientConfiguration, HTTPS))
        {
            applyProxyProperties(clientConfiguration, HTTP);
        }
        return clientConfiguration;
    }

    /**
     * Update client configuration with the http(s).proxyHost and http(s).proxyPort system properties if they are
     * defined.
     *
     * @param clientConfiguration the client configuration to modify
     * @param protocol - either "http" or "https"
     */
    private static boolean applyProxyProperties(final ClientConfiguration clientConfiguration, final String protocol)
    {
        final String proxyHost = getSystemProperty(protocol, "proxyHost");
        final String proxyPortString = getSystemProperty(protocol, "proxyPort");
        final int proxyPort = toInt(proxyPortString, -1);
        if (proxyHost == null || proxyPort <= 0)
        {
            return false;
        }
        clientConfiguration
                .withProxyHost(proxyHost)
                .withProxyPort(proxyPort);
        final String proxyDomain = getSystemProperty(protocol, "proxyDomain");
        final String proxyUser = getSystemProperty(protocol, "proxyUser");
        final String proxyPassword = getSystemProperty(protocol, "proxyPassword");
        final String proxyWorkstation = getSystemProperty(protocol, "proxyWorkstation");

        clientConfiguration
                .withProxyUsername(proxyUser)
                .withProxyPassword(proxyPassword)
                .withProxyDomain(proxyDomain)
                .withProxyWorkstation(proxyWorkstation);
        return true;
    }

    private static String getSystemProperty(final String protocol, final String proxyHost)
    {
        return System.getProperty(protocol + "." + proxyHost);
    }

    public static int toInt(String str, int defaultValue)
    {
        if (str == null)
        {
            return defaultValue;
        }
        try
        {
            return Integer.parseInt(str);
        }
        catch (final NumberFormatException e)
        {
            return defaultValue;
        }
    }
}
