package com.atlassian.aws.ec2;

import com.atlassian.aws.utils.URLFetcherUtils;

import java.io.IOException;

class LocalEC2InstanceImpl implements EC2Instance
{
    private static final String INSTANCE_ID_URL = Ec2UtilsThin.META_DATA_BASE_URL + "instance-id";
    private String instanceId;

    @Override
    public synchronized String getInstanceId() throws IOException
    {
        if (instanceId==null)
        {
            instanceId = fetchInstanceId();
        }
        return instanceId;
    }

    private String fetchInstanceId()
    {
        try
        {
            return URLFetcherUtils.getURLFetcher().fetchString(INSTANCE_ID_URL);
        }
        catch (final IOException e)
        {
            throw new IllegalStateException(e);
        }
    }
}
