package com.atlassian.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Region;
import com.atlassian.aws.s3.BambooAmazonS3Client;
import com.atlassian.aws.s3.S3Support;
import org.apache.log4j.Logger;

import java.util.concurrent.TimeUnit;

public class AmazonClients
{
    private static final int DEFAULT_TRANSMISSION_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(30);
    private static final int DEFAULT_MAX_RETRIES = 5;

    private static final Logger log = Logger.getLogger(AmazonClients.class);

    private AmazonClients()
    {
    }

    public static BambooAmazonS3Client newAmazonS3Client(final AWSCredentials awsCredentials)
    {
        final ClientConfiguration clientConfiguration = HttpClientConfigurationUtilsDoNotUse.newClientConfiguration(DEFAULT_TRANSMISSION_TIMEOUT_MS, DEFAULT_MAX_RETRIES);
        return new BambooAmazonS3Client(awsCredentials, clientConfiguration);
    }

    public static void setBestEndpointForBucket(final AmazonS3 s3Client, final String bucketName)
    {
        log.info("Detecting bucket location for [" + bucketName + "]");
        final String bucketLocation;
        try
        {
            bucketLocation = s3Client.getBucketLocation(bucketName);
        }
        catch (final AmazonClientException e)
        {
            log.warn("Unable to get bucket location for [" + bucketName + "], using default. Error: " + e);
            log.debug("", e);
            return;
        }
        try
        {
            final Region region = Region.fromValue(bucketLocation);
            final com.amazonaws.regions.Region awsRegion = region.toAWSRegion();
            s3Client.setRegion(awsRegion);
            log.info("Set S3 endpoint to: " + S3Support.getEndpoint(awsRegion));
        }
        catch (final IllegalArgumentException e)
        {
            log.warn("Unable to get bucket location, using default.", e);
        }
    }
}
