/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.s3;

public final class S3Path {
    private static final String S3_PROTOCOL = "s3://";
    private static final int PATH_COMPONENTS = 4;
    private final String bucket;
    private final String key;

    public S3Path(String bucket, String key) {
        this.bucket = bucket;
        this.key = S3Path.stripTrailingSlash(key);
    }

    public S3Path(String srcPath) {
        if (!this.isS3Path(srcPath)) {
            throw new IllegalArgumentException(srcPath + " is not an S3 path");
        }
        String[] split = srcPath.split("/", 4);
        this.bucket = split[2];
        this.key = split.length == 4 ? S3Path.stripTrailingSlash(split[3]) : "";
    }

    private static String stripTrailingSlash(String s) {
        return s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
    }

    private boolean isS3Path(String srcPath) {
        return srcPath.startsWith(S3_PROTOCOL);
    }

    @Deprecated
    public String getDirectory() {
        return this.key;
    }

    public String getKey() {
        return this.key;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String toString() {
        return S3_PROTOCOL + this.bucket + '/' + this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3Path s3Path = (S3Path)o;
        if (!this.bucket.equals(s3Path.bucket)) {
            return false;
        }
        return this.key.equals(s3Path.key);
    }

    public int hashCode() {
        int result = this.bucket.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }
}

