/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Region;
import com.atlassian.aws.HttpClientConfigurationUtilsDoNotUse;
import com.atlassian.aws.s3.BambooAmazonS3Client;
import com.atlassian.aws.s3.S3Support;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class AmazonClients {
    private static final int DEFAULT_TRANSMISSION_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static final Logger log = Logger.getLogger(AmazonClients.class);

    private AmazonClients() {
    }

    public static BambooAmazonS3Client newAmazonS3Client(AWSCredentials awsCredentials) {
        ClientConfiguration clientConfiguration = HttpClientConfigurationUtilsDoNotUse.newClientConfiguration(DEFAULT_TRANSMISSION_TIMEOUT_MS, 5);
        return new BambooAmazonS3Client(awsCredentials, clientConfiguration);
    }

    public static void setBestEndpointForBucket(AmazonS3 s3Client, String bucketName) {
        String bucketLocation;
        log.info((Object)("Detecting bucket location for [" + bucketName + "]"));
        try {
            bucketLocation = s3Client.getBucketLocation(bucketName);
        }
        catch (AmazonClientException e) {
            log.warn((Object)("Unable to get bucket location for [" + bucketName + "], using default. Error: " + (Object)((Object)e)));
            log.debug((Object)"", (Throwable)e);
            return;
        }
        try {
            Region region = Region.fromValue((String)bucketLocation);
            com.amazonaws.regions.Region awsRegion = region.toAWSRegion();
            s3Client.setRegion(awsRegion);
            log.info((Object)("Set S3 endpoint to: " + S3Support.getEndpoint(awsRegion)));
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)"Unable to get bucket location, using default.", (Throwable)e);
        }
    }
}

