package com.atlassian.aws.utils;

import com.atlassian.aws.ec2.Ec2UtilsThin;
import org.jetbrains.annotations.NotNull;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

class URLFetcherImpl implements URLFetcher
{

    @NotNull
    @Override
    public String fetchString(final String url)
            throws IOException
    {
        return new String(fetchData(url), Ec2UtilsThin.CHARSET_UTF_8);
    }

    @NotNull
    @Override
    public byte[] fetchData(String url) throws IOException
    {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final InputStream inputStream = new URL(url).openStream();
        try
        {
            final byte[] buffer = new byte[16 * 1024];
            int read;
            while ((read = inputStream.read(buffer)) >= 0)
            {
                baos.write(buffer, 0, read);
            }
        }
        finally
        {
            inputStream.close();
        }
        return baos.toByteArray();
    }
}
