package com.atlassian.aws.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Type;
import java.security.KeyStore;
import java.util.Base64;

public class JsonUtils
{
    public static Gson gson;

    static
    {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(KeyStore.class, new KeyStoreMarshaller());
        gson = builder.create();
    }

    public static <T> T fromJson(String json, Class<T> classOfT) throws JsonSyntaxException
    {
        return gson.fromJson(json, classOfT);
    }

    public static String toJson(Object userData)
    {
        return gson.toJson(userData);
    }

    private static class KeyStoreMarshaller implements JsonSerializer<KeyStore>, JsonDeserializer<KeyStore>
    {
        static final String KEY_STORE_PASSWORD = "bamboo";

        @Override
        public JsonElement serialize(final KeyStore keyStore, final Type type, final JsonSerializationContext jsonSerializationContext)
        {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add(new JsonPrimitive(keyStore.getType()));

            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try
            {
                keyStore.store(byteArrayOutputStream, KEY_STORE_PASSWORD.toCharArray());
            }
            catch (Exception e)
            {
                throw new IllegalStateException(e);
            }

            final String keyStoreContents = Base64.getMimeEncoder().encodeToString(byteArrayOutputStream.toByteArray());

            jsonArray.add(new JsonPrimitive(keyStoreContents));

            return jsonArray;
        }

        @Override
        public KeyStore deserialize(final JsonElement jsonElement, final Type type, final JsonDeserializationContext jsonDeserializationContext) throws JsonParseException
        {
            JsonArray array = jsonElement.getAsJsonArray();
            try
            {
                final JsonElement keyStoreType = array.get(0);
                final JsonElement keyStoreContent = array.get(1);

                KeyStore keyStore = KeyStore.getInstance(keyStoreType.getAsString());

                final byte[] decoded = Base64.getMimeDecoder().decode(keyStoreContent.getAsString());

                keyStore.load(new ByteArrayInputStream(decoded), KEY_STORE_PASSWORD.toCharArray());

                return keyStore;
            }
            catch (Exception e)
            {
                throw new JsonParseException("Could not deserialize keystore", e);
            }
        }
    }
}
