/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aui.auipageobjects;

import com.atlassian.annotations.Internal;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class AuiFormField
extends WebDriverElement {
    @Inject
    protected PageElementFinder elementFinder;

    public AuiFormField(By locator) {
        super(locator);
    }

    public AuiFormField(By locator, TimeoutType defaultTimeout) {
        super(locator, defaultTimeout);
    }

    public AuiFormField(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public AuiFormField(By locator, WebDriverLocatable parent) {
        super(locator, parent);
    }

    public AuiFormField(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        super(locator, parent, timeoutType);
    }

    public boolean isVisible() {
        return this.getAssociatedLabel().isVisible();
    }

    public boolean isPresent() {
        return super.isPresent() && this.getAssociatedLabel().isPresent();
    }

    @Nonnull
    public PageElement click() {
        this.getAssociatedLabel().click();
        return this;
    }

    @Nonnull
    public PageElement toggle() {
        if (this.getAssociatedLabel().isSelected()) {
            this.getAssociatedLabel().click();
        } else {
            this.getAssociatedLabel().select();
        }
        return this;
    }

    @Nonnull
    public PageElement select() {
        if (!this.isSelected()) {
            this.getAssociatedLabel().click();
        }
        return this;
    }

    @Nonnull
    private PageElement getAssociatedLabel() {
        String fieldId = this.getId();
        if (fieldId == null || fieldId.isEmpty()) {
            throw new NoSuchElementException("A form field needs to have the 'id' which must be referenced by the associated label");
        }
        LabelRequiredElement labelRequiredElement = (LabelRequiredElement)this.elementFinder.find(By.cssSelector((String)("label[for=\"" + fieldId + "\"]")), LabelRequiredElement.class, this.getDefaultTimeout());
        labelRequiredElement.setParentLocatable(this.locatable);
        return labelRequiredElement;
    }

    @Internal
    public static class LabelRequiredElement
    extends WebDriverElement {
        private WebDriverLocatable parentLocatable;

        public LabelRequiredElement(By locator) {
            super(locator);
        }

        public LabelRequiredElement(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public LabelRequiredElement(By locator, WebDriverLocatable parent) {
            super(locator, parent);
        }

        public LabelRequiredElement(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
            super(locator, parent, timeoutType);
        }

        public LabelRequiredElement(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        protected WebElement waitForWebElement() {
            try {
                return super.waitForWebElement();
            }
            catch (NoSuchElementException e) {
                return this.throwException(e);
            }
        }

        protected WebElement waitForWebElement(WebDriverLocatable.LocateTimeout timeout) {
            try {
                return super.waitForWebElement(timeout);
            }
            catch (NoSuchElementException e) {
                return this.throwException(e);
            }
        }

        private WebElement throwException(NoSuchElementException e) {
            throw new NoSuchElementException(String.format("Couldn't find label for this AuiFormField(%s). Location: %s", this.parentLocatable, this.locatable), (Throwable)e);
        }

        private void setParentLocatable(WebDriverLocatable parentLocatable) {
            this.parentLocatable = parentLocatable;
        }
    }
}

