/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.rest.model.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.Period;
import java.util.Optional;

public class PeriodDeserializer
extends JsonDeserializer<Period> {
    public Period deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode root = (JsonNode)jsonParser.readValueAsTree();
        int years = Optional.ofNullable(root.get("years")).map(JsonNode::asInt).orElse(0);
        int months = Optional.ofNullable(root.get("months")).map(JsonNode::asInt).orElse(0);
        int days = Optional.ofNullable(root.get("days")).map(JsonNode::asInt).orElse(0);
        return Period.of(years, months, days);
    }
}

