/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.search;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.audit.ao.dao.entity.AoAuditEntity;
import com.atlassian.audit.ao.dao.entity.AoAuditEntityCategory;
import com.atlassian.audit.coverage.SingleValueCache;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.java.ao.Query;

public class CategoriesProvider {
    private final ActiveObjects ao;
    private final TransactionTemplate transactionTemplate;
    private final SingleValueCache<Set<String>> categoriesCache;

    public CategoriesProvider(ActiveObjects ao, TransactionTemplate transactionTemplate, int refreshIntervalInSeconds) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.categoriesCache = new SingleValueCache<Set>(this::queryDistinctCategories, (long)refreshIntervalInSeconds, TimeUnit.SECONDS);
    }

    @Nonnull
    private Set<String> queryDistinctCategories() {
        return Arrays.stream((Object[])this.transactionTemplate.execute(() -> (AoAuditEntityCategory[])this.ao.find(AoAuditEntityCategory.class, Query.select((String)"CATEGORY").distinct()))).map(AoAuditEntity::getCategory).collect(Collectors.toSet());
    }

    public List<String> getCategories() {
        return this.categoriesCache.get().stream().sorted().collect(Collectors.toList());
    }
}

