/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.schedule;

import com.atlassian.audit.retention.RetentionScheduler;
import com.atlassian.audit.schedule.db.limit.DbLimiterScheduler;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AuditScheduler
implements InitializingBean,
DisposableBean {
    private static final String PLUGIN_KEY = "com.atlassian.audit.atlassian-audit-plugin";
    private final EventPublisher eventPublisher;
    private final RetentionScheduler retentionScheduler;
    private final DbLimiterScheduler dbLimiterScheduler;

    public AuditScheduler(EventPublisher eventPublisher, RetentionScheduler retentionScheduler, DbLimiterScheduler dbLimiterScheduler) {
        this.eventPublisher = eventPublisher;
        this.retentionScheduler = retentionScheduler;
        this.dbLimiterScheduler = dbLimiterScheduler;
    }

    private void registerJob() {
        this.retentionScheduler.registerJob();
        this.dbLimiterScheduler.registerJob();
    }

    private void unregisterJob() {
        this.retentionScheduler.unregisterJob();
        this.dbLimiterScheduler.unregisterJob();
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            this.registerJob();
        }
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        if (PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            this.unregisterJob();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        this.unregisterJob();
    }
}

