/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.plugin.configuration;

import com.atlassian.audit.api.AuditSearchService;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.coverage.InternalAuditCoverageConfigService;
import com.atlassian.audit.coverage.LicenseDowngradeListener;
import com.atlassian.audit.coverage.ProductLicenseChecker;
import com.atlassian.audit.csv.AuditCsvExportService;
import com.atlassian.audit.csv.SelectiveExportLicenseChecker;
import com.atlassian.audit.permission.PermissionChecker;
import com.atlassian.audit.permission.SysPropBasedPermissionChecker;
import com.atlassian.audit.plugin.AuditPluginInfo;
import com.atlassian.audit.plugin.configuration.AuditBrokerConfiguration;
import com.atlassian.audit.plugin.configuration.AuditConfigConfiguration;
import com.atlassian.audit.plugin.configuration.AuditConsumersConfiguration;
import com.atlassian.audit.plugin.configuration.AuditSearchConfiguration;
import com.atlassian.audit.plugin.configuration.AuditServiceConfiguration;
import com.atlassian.audit.plugin.configuration.AuditUpgradeConfiguration;
import com.atlassian.audit.plugin.configuration.FrontendConfiguration;
import com.atlassian.audit.plugin.configuration.PermissionsNotEnforced;
import com.atlassian.audit.plugin.configuration.PropertiesProvider;
import com.atlassian.audit.plugin.configuration.SystemThenSalPropertiesProvider;
import com.atlassian.audit.plugin.configuration.condition.Method;
import com.atlassian.audit.plugin.configuration.condition.MethodFound;
import com.atlassian.audit.plugin.configuration.condition.MethodNotFound;
import com.atlassian.audit.plugin.onboarding.OnboardingRestResource;
import com.atlassian.audit.plugin.onboarding.OnboardingSeenService;
import com.atlassian.audit.service.DefaultTranslationService;
import com.atlassian.audit.service.TranslationService;
import com.atlassian.audit.service.TranslationServiceInconsistentSiteLocale;
import com.atlassian.audit.spi.entity.AuditEntityTransformationService;
import com.atlassian.audit.spi.feature.DelegatedViewFeature;
import com.atlassian.audit.spi.lookup.AuditingResourcesLookupService;
import com.atlassian.audit.spi.permission.ResourceContextPermissionChecker;
import com.atlassian.audit.transform.ErrorIgnoredTransformationService;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.sal.api.websudo.WebSudoManager;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AuditConfigConfiguration.class, AuditConsumersConfiguration.class, AuditSearchConfiguration.class, AuditUpgradeConfiguration.class, FrontendConfiguration.class, AuditBrokerConfiguration.class, AuditServiceConfiguration.class})
public class SpringConfiguration {
    @Bean
    public PluginAccessor pluginAccessor() {
        return OsgiServices.importOsgiService(PluginAccessor.class);
    }

    @Bean
    public ProductLicenseChecker licenseChecker(LicenseHandler licenseHandler) {
        return new ProductLicenseChecker(licenseHandler);
    }

    @Bean
    public ResourceContextPermissionChecker resourceContextPermissionChecker() {
        return OsgiServices.importOsgiService(ResourceContextPermissionChecker.class);
    }

    @Bean
    public DelegatedViewFeature delegatedViewFeatureChecker() {
        return OsgiServices.importOsgiService(DelegatedViewFeature.class);
    }

    @Bean
    public PermissionChecker permissionChecker(UserManager userManager, ResourceContextPermissionChecker resourceContextPermissionChecker, PropertiesProvider propertiesProvider) {
        return new SysPropBasedPermissionChecker(userManager, resourceContextPermissionChecker, propertiesProvider);
    }

    @Bean
    public LicenseDowngradeListener licenseDowngradeListener(ProductLicenseChecker licenseChecker, @PermissionsNotEnforced InternalAuditCoverageConfigService configServiceSupplier, EventListenerRegistrar eventListenerRegistrar) {
        return new LicenseDowngradeListener(licenseChecker, configServiceSupplier, eventListenerRegistrar);
    }

    @Bean
    @Method(of=LocaleResolver.class, method="getApplicationLocale")
    @Conditional(value={MethodNotFound.class})
    public TranslationService inconsistentTranslationService(I18nResolver i18nResolver, LocaleResolver localeResolver) {
        return new TranslationServiceInconsistentSiteLocale(i18nResolver, localeResolver);
    }

    @Bean
    @Method(of=LocaleResolver.class, method="getApplicationLocale")
    @Conditional(value={MethodFound.class})
    public TranslationService translationService(I18nResolver i18nResolver, LocaleResolver localeResolver) {
        return new DefaultTranslationService(i18nResolver, localeResolver);
    }

    @Bean
    public WebResourceUrlProvider webResourceUrlProvider() {
        return OsgiServices.importOsgiService(WebResourceUrlProvider.class);
    }

    @Bean
    public OnboardingRestResource onboardingRestResource(OnboardingSeenService onboardingSeenService) {
        return new OnboardingRestResource(onboardingSeenService);
    }

    @Bean
    public OnboardingSeenService onboardingSeenService(UserManager userManager, PluginSettingsFactory pluginSettingsFactory, PermissionChecker permissionChecker) {
        return new OnboardingSeenService(userManager, pluginSettingsFactory, permissionChecker);
    }

    @Bean
    public AuditCsvExportService auditWriteService(SelectiveExportLicenseChecker licenseChecker, AuditSearchService searchService, I18nResolver resolver, HttpContext httpContextSupplier, EventPublisher eventPublisher, AuditPluginInfo auditPluginInfo, AuditService auditService) {
        return new AuditCsvExportService(licenseChecker, searchService, resolver, httpContextSupplier, eventPublisher, auditPluginInfo, auditService);
    }

    @Bean
    public UserManager userManagerFactoryBean() {
        return OsgiServices.importOsgiService(UserManager.class);
    }

    @Bean
    public I18nResolver i18nResolverFactoryBean() {
        return OsgiServices.importOsgiService(I18nResolver.class);
    }

    @Bean
    public SelectiveExportLicenseChecker selectiveExportLicenseChecker(ProductLicenseChecker productLicenseChecker, ApplicationProperties applicationPropertiesSupplier) {
        return new SelectiveExportLicenseChecker(productLicenseChecker, applicationPropertiesSupplier);
    }

    @Bean
    public AuditEntityTransformationService entityTransformationServiceSupplier() {
        return new ErrorIgnoredTransformationService(OsgiServices.importOsgiService(AuditEntityTransformationService.class));
    }

    @Bean
    public ApplicationProperties applicationProperties() {
        return OsgiServices.importOsgiService(ApplicationProperties.class);
    }

    @Bean
    public WebSudoManager webSudoManager() {
        return OsgiServices.importOsgiService(WebSudoManager.class);
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return mapper;
    }

    @Bean
    public AuditingResourcesLookupService auditResourceLookupProvider() {
        return OsgiServices.importOsgiService(AuditingResourcesLookupService.class);
    }

    @Bean
    public AuditPluginInfo auditPluginInfo(PluginAccessor pluginAccessor) {
        return new AuditPluginInfo(pluginAccessor);
    }

    @Bean
    public PropertiesProvider propertiesProvider(ApplicationProperties applicationPropertiesSupplier) {
        return new SystemThenSalPropertiesProvider(applicationPropertiesSupplier);
    }
}

