/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.plugin.configuration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.audit.ao.dao.AuditEntityDao;
import com.atlassian.audit.api.AuditCoverageConfigService;
import com.atlassian.audit.api.AuditRetentionConfigService;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.coverage.AnalyticsTrackedCoverageConfigService;
import com.atlassian.audit.coverage.AuditedCoverageConfigService;
import com.atlassian.audit.coverage.InternalAuditCoverageConfigService;
import com.atlassian.audit.coverage.LicenseAwareCoverageConfigService;
import com.atlassian.audit.coverage.ProductLicenseChecker;
import com.atlassian.audit.coverage.RestrictiveCoverageConfigService;
import com.atlassian.audit.coverage.SalAuditCoverageConfigService;
import com.atlassian.audit.file.AuditRetentionFileConfigLicenseChecker;
import com.atlassian.audit.file.AuditRetentionFileConfigService;
import com.atlassian.audit.permission.PermissionChecker;
import com.atlassian.audit.plugin.AuditPluginInfo;
import com.atlassian.audit.plugin.configuration.PermissionsEnforced;
import com.atlassian.audit.plugin.configuration.PermissionsNotEnforced;
import com.atlassian.audit.plugin.configuration.PropertiesProvider;
import com.atlassian.audit.retention.RestrictiveRetentionConfigService;
import com.atlassian.audit.retention.RestrictiveRetentionFileConfigService;
import com.atlassian.audit.retention.RetentionScheduler;
import com.atlassian.audit.retention.SalAuditRetentionConfigService;
import com.atlassian.audit.retention.SalAuditRetentionFileConfigService;
import com.atlassian.audit.schedule.AuditScheduler;
import com.atlassian.audit.schedule.db.limit.DbLimiterScheduler;
import com.atlassian.audit.search.ActionsProvider;
import com.atlassian.audit.search.CategoriesProvider;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.SchedulerService;
import java.util.function.Supplier;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuditConfigConfiguration {
    @Bean
    public FactoryBean<ServiceRegistration> exportAuditCoverageService(@PermissionsEnforced AuditCoverageConfigService configService) {
        return OsgiServices.exportOsgiService(configService, ExportOptions.as(AuditCoverageConfigService.class, new Class[0]));
    }

    @Bean
    public FactoryBean<ServiceRegistration> exportAuditRetentionService(@PermissionsEnforced AuditRetentionConfigService auditRetentionConfigService) {
        return OsgiServices.exportOsgiService(auditRetentionConfigService, ExportOptions.as(AuditRetentionConfigService.class, new Class[0]));
    }

    @Bean
    @PermissionsEnforced
    public InternalAuditCoverageConfigService restrictiveAuditCoverageConfigService(PermissionChecker permissionChecker, @PermissionsNotEnforced InternalAuditCoverageConfigService configService, EventPublisher eventPublisher, AuditPluginInfo auditPluginInfo, AuditService auditService) {
        return new RestrictiveCoverageConfigService(permissionChecker, new AnalyticsTrackedCoverageConfigService(new AuditedCoverageConfigService(configService, auditService), eventPublisher, auditPluginInfo));
    }

    @Bean
    @PermissionsNotEnforced
    public InternalAuditCoverageConfigService internalAuditCoverageConfigService(PluginSettingsFactory factory, ProductLicenseChecker licenseChecker, EventPublisher eventPublisher) {
        return new LicenseAwareCoverageConfigService(licenseChecker, new SalAuditCoverageConfigService(factory, this.eventPublisher()));
    }

    @Bean
    @PermissionsEnforced
    public Supplier<AuditRetentionConfigService> restrictiveRetentionConfigServiceSupplier(@PermissionsEnforced AuditRetentionConfigService configService) {
        return () -> configService;
    }

    @Bean
    @PermissionsEnforced
    public AuditRetentionConfigService restrictiveRetentionConfigService(PermissionChecker permissionChecker, @PermissionsNotEnforced AuditRetentionConfigService configService) {
        return new RestrictiveRetentionConfigService(permissionChecker, configService);
    }

    @Bean
    @PermissionsEnforced
    public AuditRetentionFileConfigService restrictiveRetentionFileConfigService(PermissionChecker permissionChecker, @PermissionsNotEnforced AuditRetentionFileConfigService configService, AuditRetentionFileConfigLicenseChecker auditRetentionFileConfigLicenseChecker) {
        return new RestrictiveRetentionFileConfigService(permissionChecker, configService, auditRetentionFileConfigLicenseChecker);
    }

    @Bean
    public AuditRetentionFileConfigLicenseChecker auditRetentionFileConfigLicenseChecker(ProductLicenseChecker productLicenseChecker, ApplicationProperties applicationPropertiesSupplier) {
        return new AuditRetentionFileConfigLicenseChecker(productLicenseChecker, applicationPropertiesSupplier);
    }

    @Bean
    @PermissionsNotEnforced
    public AuditRetentionConfigService auditRetentionConfigService(EventPublisher eventPublisher, AuditPluginInfo auditPluginInfo, PluginSettingsFactory pluginSettingsFactory, AuditService auditService) {
        return new SalAuditRetentionConfigService(eventPublisher, auditPluginInfo, pluginSettingsFactory, auditService);
    }

    @Bean
    @PermissionsNotEnforced
    public AuditRetentionFileConfigService auditRetentionFileConfigService(EventPublisher eventPublisher, AuditPluginInfo auditPluginInfo, PluginSettingsFactory pluginSettingsFactory, AuditService auditService, PropertiesProvider propertiesProvider) {
        return new SalAuditRetentionFileConfigService(eventPublisher, auditPluginInfo, pluginSettingsFactory, auditService, propertiesProvider);
    }

    @Bean
    public PluginSettingsFactory pluginSettingsFactory() {
        return OsgiServices.importOsgiService(PluginSettingsFactory.class);
    }

    @Bean
    public SchedulerService schedulerService() {
        return OsgiServices.importOsgiService(SchedulerService.class);
    }

    @Bean
    public EventPublisher eventPublisher() {
        return OsgiServices.importOsgiService(EventPublisher.class);
    }

    @Bean
    public RetentionScheduler retentionScheduler(SchedulerService schedulerService, @PermissionsNotEnforced AuditRetentionConfigService auditRetentionConfigService, AuditEntityDao auditEntityDao, PluginSettingsFactory pluginSettingsFactory, PropertiesProvider propertiesProvider) {
        return new RetentionScheduler(schedulerService, auditRetentionConfigService, auditEntityDao, pluginSettingsFactory, propertiesProvider);
    }

    @Bean
    public DbLimiterScheduler dbLimiterScheduler(SchedulerService schedulerService, AuditEntityDao auditEntityDao, PropertiesProvider propertiesProvider) {
        return new DbLimiterScheduler(schedulerService, auditEntityDao, propertiesProvider);
    }

    @Bean
    public AuditScheduler auditScheduler(EventPublisher eventPublisher, RetentionScheduler retentionScheduler, DbLimiterScheduler dbLimiterScheduler) {
        return new AuditScheduler(eventPublisher, retentionScheduler, dbLimiterScheduler);
    }

    @Bean
    public CategoriesProvider internalDatabaseAuditSearchService(ActiveObjects ao, TransactionTemplate transactionTemplate, PropertiesProvider propertiesProvider) {
        int refreshIntervalInSeconds = propertiesProvider.getInteger("plugin.audit.distinct.categories.and.actions.cache.refresh.seconds", 900);
        return new CategoriesProvider(ao, transactionTemplate, refreshIntervalInSeconds);
    }

    @Bean
    public ActionsProvider actionsProvider(ActiveObjects ao, TransactionTemplate transactionTemplate, PropertiesProvider propertiesProvider) {
        int refreshIntervalInSeconds = propertiesProvider.getInteger("plugin.audit.distinct.categories.and.actions.cache.refresh.seconds", 900);
        return new ActionsProvider(ao, transactionTemplate, refreshIntervalInSeconds);
    }
}

