/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.ao.service;

import com.atlassian.audit.ao.dao.AuditEntityDao;
import com.atlassian.audit.coverage.SingleValueCache;
import java.util.concurrent.TimeUnit;

public class CachedCountService {
    private final AuditEntityDao dao;
    private final SingleValueCache<Long> countCache;

    public CachedCountService(AuditEntityDao dao, int cacheExpirationInMinutes) {
        this.dao = dao;
        this.countCache = new SingleValueCache<Long>(this::getCountFromDatabase, (long)cacheExpirationInMinutes, TimeUnit.MINUTES);
    }

    public long count() {
        return this.countCache.get();
    }

    private long getCountFromDatabase() {
        return this.dao.count();
    }
}

