package com.atlassian.audit.transform;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.audit.spi.entity.AuditEntityTransformationService;
import org.slf4j.Logger;

import javax.annotation.Nonnull;
import java.util.List;

import static org.slf4j.LoggerFactory.getLogger;

public class ErrorIgnoredTransformationService implements AuditEntityTransformationService {

    private static final Logger log = getLogger(ErrorIgnoredTransformationService.class);

    private final AuditEntityTransformationService delegate;

    public ErrorIgnoredTransformationService(AuditEntityTransformationService delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public List<AuditEntity> transform(@Nonnull List<AuditEntity> auditEntities) {
        try {
            auditEntities = delegate.transform(auditEntities);
        } catch (RuntimeException e) {
            log.error("Failed to invoke AuditEntityTransformationService.", e);
        }
        return auditEntities;
    }
}
