package com.atlassian.audit.service;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;

import java.util.Locale;

/**
 * This implementation of TranslationService serves where SAL 4.4.0 has not been provided. Due to inconsistency in implementing
 * getLocale() Confluence and Jira when given no user will return the SITE locale,
 * Bitbucket however will return the default locale (EN_us).
 *
 * Once SAL 4.4.0 is provided by all products this class can be removed.
 */
public class TranslationServiceInconsistentSiteLocale implements TranslationService {
    private final I18nResolver i18nResolver;
    private final LocaleResolver localeResolver;

    public TranslationServiceInconsistentSiteLocale(I18nResolver i18nResolver, LocaleResolver localeResolver) {
        this.i18nResolver = i18nResolver;
        this.localeResolver = localeResolver;
    }

    public String getSiteLocaleText(String key) {
        return i18nResolver.getText(getSiteLocale(), key);
    }

    private Locale getSiteLocale() {
        return localeResolver.getLocale((UserKey) null);
    }

    @Override
    public Locale getUserLocale() {
        return localeResolver.getLocale();
    }
}
