package com.atlassian.audit.schedule;

import com.atlassian.audit.retention.RetentionScheduler;
import com.atlassian.audit.schedule.db.limit.DbLimiterScheduler;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AuditScheduler implements InitializingBean, DisposableBean {

    private static final String PLUGIN_KEY = "com.atlassian.audit.atlassian-audit-plugin";

    private final EventPublisher eventPublisher;
    private final RetentionScheduler retentionScheduler;
    private final DbLimiterScheduler dbLimiterScheduler;

    public AuditScheduler(EventPublisher eventPublisher, RetentionScheduler retentionScheduler, DbLimiterScheduler dbLimiterScheduler) {
        this.eventPublisher = eventPublisher;
        this.retentionScheduler = retentionScheduler;
        this.dbLimiterScheduler = dbLimiterScheduler;
    }

    private void registerJob() {
        retentionScheduler.registerJob();
        dbLimiterScheduler.registerJob();
    }

    private void unregisterJob() {
        retentionScheduler.unregisterJob();
        dbLimiterScheduler.unregisterJob();
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            registerJob();
        }
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        if (PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            unregisterJob();
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        eventPublisher.register(this);
    }

    @Override
    public void destroy() throws Exception {
        eventPublisher.unregister(this);
        unregisterJob();
    }
}
