package com.atlassian.audit.retention;

import com.atlassian.audit.api.AuditRetentionConfig;
import com.atlassian.audit.api.AuditRetentionConfigService;
import com.atlassian.audit.permission.PermissionChecker;
import com.atlassian.plugins.rest.common.security.AuthorisationException;

import javax.annotation.Nonnull;

/**
 * A delegate which fails if the user doesn't have permissions to view / update retention config.
 */
public class RestrictiveRetentionConfigService implements AuditRetentionConfigService {

    private final PermissionChecker permissionChecker;

    private final AuditRetentionConfigService origin;

    public RestrictiveRetentionConfigService(PermissionChecker permissionChecker, AuditRetentionConfigService origin) {
        this.permissionChecker = permissionChecker;
        this.origin = origin;
    }

    @Nonnull
    @Override
    public AuditRetentionConfig getConfig() {
        if (!permissionChecker.hasRetentionConfigViewPermission()) {
            throw new AuthorisationException("The user is not allowed to view audit retention configuration");
        }
        return origin.getConfig();
    }

    @Override
    public void updateConfig(@Nonnull AuditRetentionConfig config) {
        if (!permissionChecker.hasRetentionConfigUpdatePermission()) {
            throw new AuthorisationException("The user is not allowed to update audit retention configuration");
        }
        origin.updateConfig(config);
    }

}
