package com.atlassian.audit.rest.validation.mapper;

import com.atlassian.audit.rest.model.ResponseErrorJson;
import com.atlassian.audit.rest.validation.exception.InvalidQueryException;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import java.time.Instant;

/**
 * Maps exceptions to responses in JAX-RS
 */
@Provider
public class InvalidQueryExceptionMapper implements ExceptionMapper<InvalidQueryException> {

    @Override
    public Response toResponse(InvalidQueryException e) {
        return Response.status(Response.Status.BAD_REQUEST)
                .entity(new ResponseErrorJson(
                        Response.Status.BAD_REQUEST.getStatusCode(),
                        e.getMessage(),
                        e.getValidationResult().getErrors(),
                        Instant.now().toString()
                ))
                .build();
    }
}
