package com.atlassian.audit.rest.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Associates a query param with an instance of a ParamValidator
 * This does nothing until {@link ValidationInterceptor} is added to the method
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface Validator {
    Class<? extends QueryParamValidator> value();
}
