package com.atlassian.audit.plugin.upgrade.task;

import com.atlassian.audit.ao.consumer.DatabaseAuditConsumer;
import com.atlassian.audit.plugin.upgrade.AuditUpgradeTask;
import com.atlassian.audit.spi.migration.LegacyAuditEntityMigrator;
import com.atlassian.sal.api.message.Message;

import java.util.Collection;

import static java.util.Collections.emptyList;
import static java.util.Objects.requireNonNull;

/**
 * This upgrade task migrate legacy audit events from products into Advanced Auditing
 */
public class UpgradeTask1MigrateLegacyEvents extends AuditUpgradeTask {
    private static final int BUILD_NUMBER = 1;
    private final LegacyAuditEntityMigrator migrator;
    private final DatabaseAuditConsumer dbAuditConsumer;

    public UpgradeTask1MigrateLegacyEvents(LegacyAuditEntityMigrator migrator,
                                           DatabaseAuditConsumer dbAuditConsumer) {
        this.migrator = requireNonNull(migrator);
        this.dbAuditConsumer = requireNonNull(dbAuditConsumer);
    }

    @Override
    public Collection<Message> doUpgrade() {
        if (dbAuditConsumer.isEnabled()) {
            migrator.migrate(dbAuditConsumer);
        }
        return emptyList();
    }

    @Override
    public int getBuildNumber() {
        return BUILD_NUMBER;
    }

    @Override
    public String getShortDescription() {
        return "Migrate legacy audit events to Advanced Auditing";
    }
}
