package com.atlassian.audit.plugin.upgrade;

import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;

import static java.util.Objects.requireNonNull;

/**
 * This adaptor is to use SAL {@link PluginUpgradeTask} as an upgrade task in the new upgrade-task-framework
 */
public class UtfUpgradeTaskAdaptor implements UpgradeTask {
    private final PluginUpgradeTask pluginUpgradeTask;

    UtfUpgradeTaskAdaptor(PluginUpgradeTask pluginUpgradeTask) {
        this.pluginUpgradeTask = requireNonNull(pluginUpgradeTask);
    }

    @Override
    public int getBuildNumber() {
        return pluginUpgradeTask.getBuildNumber();
    }

    @Override
    public String getShortDescription() {
        return pluginUpgradeTask.getShortDescription();
    }

    @Override
    public void runUpgrade(UpgradeContext upgradeContext) {
        try {
            pluginUpgradeTask.doUpgrade();
        } catch (Exception e) {
            throw new RuntimeException("Error running update task", e);
        }
    }
}
