package com.atlassian.audit.plugin.configuration.condition;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import java.util.Map;

public class MethodFound implements Condition {

    // Non-static because we want to log as the concrete subclass
    private final Logger log = LoggerFactory.getLogger(getClass());

    /**
     * A Spring bean {@link Condition} that checks whether the given class and method specified by
     * {@link Method} annotation on the bean declaration exists in our context.
     */
    @Override
    public final boolean matches(final ConditionContext conditionContext, final AnnotatedTypeMetadata metadata) {
        final Map<String, Object> annotationAttributes = metadata.getAnnotationAttributes(Method.class.getName());
        if (annotationAttributes == null) {
            log.debug("{} annotation expected in conjunction with this condition", Method.class);
            return false;
        }

        Class methodClass = (Class) annotationAttributes.get("of");
        String method = (String) annotationAttributes.get("method");

        try {
            methodClass.getMethod(method);
        } catch (NoSuchMethodException ne) {
            log.debug("Method {} not found for class {}", method, methodClass);
            return false;
        }

        return true;
    }
}
