package com.atlassian.audit.plugin.configuration.condition;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Allow specification of a class method. Intended for use in conjunction with {@link MethodFound} or {@link MethodNotFound}.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Method {

    /**
     * The class to use for method lookup.
     */
    Class of();

    /**
     * The method to lookup for the given Class.
     *
     * @return e.g. "myNewGetMethod()"
     */
    String method();
}
