package com.atlassian.audit.permission;

import com.atlassian.audit.spi.permission.ResourceContextPermissionChecker;

/**
 * This interface defines permission model for audit log system.
 */
public interface PermissionChecker extends ResourceContextPermissionChecker {

    /**
     * @return {@code true} if the current session user is allowed to view full audit log, {@code false} otherwise.
     *
     * If the method {@link #hasUnrestrictedAuditViewPermission()} returns {@code true} for some user,
     * {@link #hasResourceAuditViewPermission(String, String)} method will also return {@code true} for the same user.
     * The rationale is that if the user is allowed to see full log, they should be able to see log with any resource filter.
     */
    boolean hasUnrestrictedAuditViewPermission();

    /**
     * @return {@code true} if the current session user is allowed to view current audit coverage configuration, {@code false} otherwise.
     */
    boolean hasCoverageConfigViewPermission();

    /**
     * @return {@code true} if the current session user is allowed to update current audit coverage configuration, {@code false} otherwise.
     */
    boolean hasCoverageConfigUpdatePermission();

    /**
     * @return {@code true} if the current session user is allowed to view current audit retention configuration, {@code false} otherwise.
     */
    boolean hasRetentionConfigViewPermission();

    /**
     * @return {@code true} if the current session user is allowed to update current audit retention configuration, {@code false} otherwise.
     */
    boolean hasRetentionConfigUpdatePermission();

}
