package com.atlassian.audit.frontend.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

/**
 * Utility class for HTML form encoding. This class contains methods for converting a String to the
 * application/x-www-form-urlencoded MIME format.
 */
public final class URLEncoderUtil {
    private static final String ENCODING = StandardCharsets.UTF_8.name();

    /**
     * Translates a string into application/x-www-form-urlencoded format assuming the string is in UTF-8 as
     * recommended by W3.
     *
     * @param url UTF-8 String to encode
     * @return URL safe String
     * @throws UnsupportedEncodingException If the named encoding is not supported
     */
    public String encode(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, ENCODING);
    }
}
