package com.atlassian.audit.frontend.data;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AuditSettingsViewData {

    private String fileLocation;

    private int maxExportRecordsWarning = 10_000;

    private int maxRecordsInDb = 10_000_000;

    private int fileSizeLimitInMb = 100;

    private int maxFileCount = 100;

    private List<ConfigurationArea> areas = new ArrayList<>();

    private ConfigurationLevel levels;

    private boolean logFileEnabled;

    public AuditSettingsViewData withMaxFileCount(int maxFileCount) {
        this.maxFileCount = maxFileCount;
        return this;
    }

    public AuditSettingsViewData withFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
        return this;
    }

    public AuditSettingsViewData withLogFileEnabled(boolean logFileEnabled) {
        this.logFileEnabled = logFileEnabled;
        return this;
    }

    public AuditSettingsViewData area(ConfigurationArea area) {
        this.areas.add(area);
        return this;
    }

    public AuditSettingsViewData withMaxExportRecordsWarning(int maxExportRecordsWarning) {
        this.maxExportRecordsWarning = maxExportRecordsWarning;
        return this;
    }

    public AuditSettingsViewData withMaxRecordsInDb(int maxRecordsInDb) {
        this.maxRecordsInDb = maxRecordsInDb;
        return this;
    }

    public AuditSettingsViewData levels(ConfigurationLevel levels) {
        this.levels = levels;
        return this;
    }

    public AuditSettingsViewData withFileSizeLimitInMb(int fileSizeLimitInMb) {
        this.fileSizeLimitInMb = fileSizeLimitInMb;
        return this;
    }

    public int getMaxFileCount() {
        return maxFileCount;
    }

    public List<ConfigurationArea> getAreas() {
        return areas;
    }

    public ConfigurationLevel getLevels() {
        return levels;
    }

    public boolean isLogFileEnabled() {
        return logFileEnabled;
    }

    public int getMaxExportRecordsWarning() {
        return maxExportRecordsWarning;
    }

    public int getMaxRecordsInDb() {
        return maxRecordsInDb;
    }

    public int getFileSizeLimitInMb() {
        return fileSizeLimitInMb;
    }

    public String getFileLocation() {
        return fileLocation;
    }

    @Override
    public String toString() {
        return "AuditSettingsViewData{" +
                "fileLocation='" + fileLocation + '\'' +
                ", maxExportRecordsWarning=" + maxExportRecordsWarning +
                ", maxRecordsInDb=" + maxRecordsInDb +
                ", fileSizeLimitInMb=" + fileSizeLimitInMb +
                ", maxFileCount=" + maxFileCount +
                ", areas=" + areas +
                ", levels=" + levels +
                ", logFileEnabled=" + logFileEnabled +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditSettingsViewData)) {
            return false;
        }
        AuditSettingsViewData that = (AuditSettingsViewData) o;
        return maxExportRecordsWarning == that.maxExportRecordsWarning &&
                maxRecordsInDb == that.maxRecordsInDb &&
                fileSizeLimitInMb == that.fileSizeLimitInMb &&
                maxFileCount == that.maxFileCount &&
                logFileEnabled == that.logFileEnabled &&
                Objects.equals(fileLocation, that.fileLocation) &&
                Objects.equals(areas, that.areas) &&
                Objects.equals(levels, that.levels);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fileLocation, maxExportRecordsWarning, maxRecordsInDb, fileSizeLimitInMb, maxFileCount, areas, levels, logFileEnabled);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ConfigurationLevel {
        @JsonProperty("off")
        private String off;

        @JsonProperty("base")
        private String base;

        @JsonProperty("advanced")
        private String advanced;

        @JsonProperty("full")
        private String full;

        public ConfigurationLevel(String off, String base, String advanced, String full) {
            this.off = off;
            this.base = base;
            this.advanced = advanced;
            this.full = full;
        }

        @Override
        public String toString() {
            return "ConfigurationLevel{" +
                    "off='" + off + '\'' +
                    ", base='" + base + '\'' +
                    ", advanced='" + advanced + '\'' +
                    ", full='" + full + '\'' +
                    '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ConfigurationLevel that = (ConfigurationLevel) o;
            return Objects.equals(off, that.off) &&
                    Objects.equals(base, that.base) &&
                    Objects.equals(advanced, that.advanced) &&
                    Objects.equals(full, that.full);
        }

        @Override
        public int hashCode() {
            return Objects.hash(off, base, advanced, full);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ConfigurationArea {

        private String key;
        private String label;
        private String description;
        private List<String> levels;

        public ConfigurationArea(String key, String label, String description, String... levels) {
            this.key = key;
            this.label = label;
            this.description = description;
            this.levels = Arrays.asList(levels);
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getLevels() {
            return levels;
        }

        public void setLevels(List<String> levels) {
            this.levels = levels;
        }

        @Override
        public String toString() {
            return "ConfigurationArea{" +
                    "key='" + key + '\'' +
                    ", label='" + label + '\'' +
                    ", description='" + description + '\'' +
                    ", levels=" + levels +
                    '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ConfigurationArea that = (ConfigurationArea) o;
            return Objects.equals(key, that.key) &&
                    Objects.equals(label, that.label) &&
                    Objects.equals(description, that.description) &&
                    Objects.equals(levels, that.levels);
        }

        @Override
        public int hashCode() {
            return Objects.hash(key, label, description, levels);
        }
    }

}
