package com.atlassian.audit.frontend.data;

import com.atlassian.audit.permission.PermissionChecker;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

/**
 * Data provider to provide permission related data:
 * Is configuration UI allowed
 */
public class AuditPermissionDataProvider implements WebResourceDataProvider {

    private final ObjectMapper objectMapper;
    private final PermissionChecker permissionChecker;

    public AuditPermissionDataProvider(ObjectMapper objectMapper, PermissionChecker permissionChecker) {
        this.objectMapper = objectMapper;
        this.permissionChecker = permissionChecker;
    }

    @Override
    public Jsonable get() {
        return writer -> {
            try {
                objectMapper.writeValue(writer, getData());
            } catch (Exception e) {
                throw new JsonMappingException(e.getMessage(), e);
            }
        };
    }

    private AuditPermissionData getData() {
        return new AuditPermissionData()
                .allowUpdateConfiguration(permissionChecker.hasCoverageConfigUpdatePermission()
                        && permissionChecker.hasRetentionConfigUpdatePermission())
                // There is no Coverage View Permission check defined,
                // We need to consider consolidate the permission check
                // or/and split coverage/retention in UI in M2
                .allowViewConfiguration(permissionChecker.hasRetentionConfigViewPermission());
    }
}
