package com.atlassian.audit.frontend.data;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
public class AuditKbArticleData {

    private URI featureDescription;

    private URI reference;

    private URI integrations;

    private URI databaseRetention;

    public AuditKbArticleData(URI featureDescription, URI reference, URI integrations, URI databaseRetention) {
        this.featureDescription = featureDescription;
        this.reference = reference;
        this.integrations = integrations;
        this.databaseRetention = databaseRetention;
    }

    public URI getFeatureDescription() {
        return featureDescription;
    }

    public URI getReference() {
        return reference;
    }

    public URI getIntegrations() {
        return integrations;
    }

    public URI getDatabaseRetention() {
        return databaseRetention;
    }

    @Override
    public String toString() {
        return "AuditKbArticleData{" +
                "featureDescription=" + featureDescription +
                ", reference=" + reference +
                ", integrations=" + integrations +
                ", databaseRetention=" + databaseRetention +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuditKbArticleData that = (AuditKbArticleData) o;
        return Objects.equals(featureDescription, that.featureDescription) &&
                Objects.equals(reference, that.reference) &&
                Objects.equals(integrations, that.integrations) &&
                Objects.equals(databaseRetention, that.databaseRetention);
    }

    @Override
    public int hashCode() {
        return Objects.hash(featureDescription, reference, integrations, databaseRetention);
    }
}
