package com.atlassian.audit.coverage;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditCoverageConfig;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.EffectiveCoverageLevel;

import static com.atlassian.audit.coverage.SalAuditCoverageConfigService.*;
import static com.atlassian.audit.entity.CoverageArea.AUDIT_LOG;
import static com.atlassian.audit.entity.CoverageLevel.BASE;
import static java.lang.String.format;

public class AuditedCoverageConfigService implements InternalAuditCoverageConfigService {

    public static final AuditType AUDIT_CONFIG_UPDATED =
            AuditType.fromI18nKeys(AUDIT_LOG, BASE, "atlassian.audit.event.category.audit", "atlassian.audit.event.action.audit.config.updated").build();

    private final InternalAuditCoverageConfigService delegate;
    private final AuditService auditService;

    public AuditedCoverageConfigService(InternalAuditCoverageConfigService delegate, AuditService auditService) {
        this.delegate = delegate;
        this.auditService = auditService;
    }

    @Override
    public AuditCoverageConfig getConfig() {
        return delegate.getConfig();
    }

    @Override
    public void updateConfig(AuditCoverageConfig config) {
        AuditCoverageConfig oldConfig = delegate.getConfig();
        delegate.updateConfig(config);
        config.getLevelByArea().forEach((area, level) -> {
            EffectiveCoverageLevel oldLevel = oldConfig.getLevelByArea().get(area);
            if (!level.equals(oldLevel)) {
                auditService.audit(AuditEvent.builder(AUDIT_CONFIG_UPDATED)
                        .changedValue(ChangedValue.fromI18nKeys("atlassian.audit.event.change.coverage.level")
                                                  .from(format("%s : %s", areaToString(area), levelToString(oldLevel)))
                                                  .to(format("%s : %s", areaToString(area), levelToString(level))).build())
                        .build());
            }
        });
    }
}
