package com.atlassian.audit.coverage;

import com.atlassian.audit.analytics.LevelUpdatedEvent;
import com.atlassian.audit.entity.AuditCoverageConfig;
import com.atlassian.audit.entity.EffectiveCoverageLevel;
import com.atlassian.audit.plugin.AuditPluginInfo;
import com.atlassian.event.api.EventPublisher;

import static com.atlassian.audit.coverage.SalAuditCoverageConfigService.areaToString;
import static com.atlassian.audit.coverage.SalAuditCoverageConfigService.levelToString;

public class AnalyticsTrackedCoverageConfigService implements InternalAuditCoverageConfigService {

    private final InternalAuditCoverageConfigService delegate;
    private final EventPublisher eventPublisher;
    private final AuditPluginInfo auditPluginInfo;

    public AnalyticsTrackedCoverageConfigService(InternalAuditCoverageConfigService delegate, EventPublisher eventPublisher, AuditPluginInfo auditPluginInfo) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
        this.auditPluginInfo = auditPluginInfo;
    }

    @Override
    public AuditCoverageConfig getConfig() {
        return delegate.getConfig();
    }

    @Override
    public void updateConfig(AuditCoverageConfig config) {
        AuditCoverageConfig oldConfig = delegate.getConfig();
        delegate.updateConfig(config);
        config.getLevelByArea().forEach((area, level) -> {
            EffectiveCoverageLevel oldLevel = oldConfig.getLevelByArea().get(area);
            if (!level.equals(oldLevel)) {
                eventPublisher.publish(new LevelUpdatedEvent(areaToString(area),
                        levelToString(oldLevel), levelToString(level), auditPluginInfo.getPluginVersion()));
            }
        });
    }
}
