package com.atlassian.audit.analytics;

import com.atlassian.analytics.api.annotations.EventName;

@EventName("audit.search.timeout")
public class SearchTimeoutEvent extends BaseAnalyticEvent {

    private final boolean freetext;
    private final boolean limited;

    public SearchTimeoutEvent(boolean freetext, boolean limited, String pluginVersion) {
        super(pluginVersion);
        this.freetext = freetext;
        this.limited = limited;
    }

    public boolean isFreetext() {
        return freetext;
    }

    /**
     *  Indicates if a scanlimit is applired.
     */
    public boolean isLimited() {
        return limited;
    }
}
