/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.core;

import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryBufferingConsumer<E> {
    private final Supplier<Optional<Consumer<E>>> delegateConsumerSupplier;
    private final int bufferLimit;
    private final Consumer<E> fullBufferHandler;
    @GuardedBy(value="bufferLock")
    private final Queue<E> buffer;
    private final Object bufferLock = new Object();

    public InMemoryBufferingConsumer(Supplier<Optional<Consumer<E>>> delegateConsumerSupplier, int bufferLimit, Consumer<E> fullBufferHandler) {
        this.delegateConsumerSupplier = delegateConsumerSupplier;
        this.bufferLimit = bufferLimit;
        this.fullBufferHandler = fullBufferHandler;
        this.buffer = new LinkedList();
    }

    public void accept(E entity) {
        Optional<Consumer<E>> optionalDelegate = this.delegateConsumerSupplier.get();
        if (optionalDelegate.isPresent()) {
            this.tryFlushBuffer();
            this.dispatch(entity, optionalDelegate.get());
        } else {
            this.bufferEntity(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryFlushBuffer() {
        Object object = this.bufferLock;
        synchronized (object) {
            while (!this.buffer.isEmpty()) {
                Optional<Consumer<E>> optionalDelegate = this.delegateConsumerSupplier.get();
                if (!optionalDelegate.isPresent()) {
                    return;
                }
                this.dispatch(this.buffer.remove(), optionalDelegate.get());
            }
        }
    }

    private void dispatch(E entity, Consumer<E> delegate) {
        delegate.accept(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferEntity(E entity) {
        Object object = this.bufferLock;
        synchronized (object) {
            while (this.buffer.size() >= this.bufferLimit) {
                E oldestElement = this.buffer.remove();
                this.fullBufferHandler.accept(oldestElement);
            }
            this.buffer.add(entity);
        }
    }
}

