/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.core;

import com.atlassian.audit.api.AuditBroker;
import com.atlassian.audit.api.AuditConsumer;
import com.atlassian.audit.api.AuditPolicy;
import com.atlassian.audit.core.AuditConsumerSupplier;
import com.atlassian.audit.core.AuditConsumerSupplierRegistry;
import com.atlassian.audit.entity.AuditEntity;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DispatchingAuditBroker
implements AuditBroker {
    private static final Logger logger = LoggerFactory.getLogger(DispatchingAuditBroker.class);
    private final AuditConsumerSupplierRegistry register;
    private final AuditPolicy policy;

    public DispatchingAuditBroker(AuditConsumerSupplierRegistry register, AuditPolicy policy) {
        this.register = register;
        this.policy = policy;
    }

    public void audit(AuditEntity entity) {
        if (this.policy.pass(entity)) {
            for (AuditConsumerSupplier supplier : this.register.getSuppliers()) {
                for (AuditConsumer consumer : supplier.getConsumers()) {
                    try {
                        consumer.accept(Collections.singleton(entity));
                    }
                    catch (Exception e) {
                        logger.error("Error occurred while executing the consumer {}", (Object)consumer.getClass().getName(), (Object)e);
                    }
                }
            }
        }
    }
}

