/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.core;

import com.atlassian.audit.api.AuditBroker;
import com.atlassian.audit.api.AuditPolicy;
import com.atlassian.audit.core.AuditConsumerSupplierRegistry;
import com.atlassian.audit.core.DispatchingAuditBroker;
import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferingOnStartupAuditBroker
implements AuditBroker {
    private static final Logger logger = LoggerFactory.getLogger(BufferingOnStartupAuditBroker.class);
    private final BufferedAuditBroker bufferedAuditBroker;
    private final AuditBroker dispatchingAuditBroker;
    private final AtomicReference<AuditBroker> currentBroker;

    public BufferingOnStartupAuditBroker(AuditConsumerSupplierRegistry register, AuditPolicy policy) {
        this.dispatchingAuditBroker = new DispatchingAuditBroker(register, policy);
        this.bufferedAuditBroker = new BufferedAuditBroker(this.dispatchingAuditBroker);
        this.currentBroker = new AtomicReference<BufferedAuditBroker>(this.bufferedAuditBroker);
    }

    public void audit(AuditEntity entity) {
        this.currentBroker.get().audit(entity);
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        if (this.currentBroker.compareAndSet(this.bufferedAuditBroker, this.dispatchingAuditBroker)) {
            this.flushBufferedEvents(event);
        }
    }

    private void flushBufferedEvents(PluginFrameworkStartedEvent event) {
        this.bufferedAuditBroker.disableAndGetBuffer().forEach(this::audit);
    }

    private static final class BufferedAuditBroker
    implements AuditBroker {
        private static final int BUFFER_LIMIT = Integer.getInteger("audit.broker.buffer.limit", 1000);
        private final AuditBroker dispatchingAuditBroker;
        private final Object bufferLock = new Object();
        @GuardedBy(value="bufferLock")
        private List<AuditEntity> buffer = new ArrayList<AuditEntity>(BUFFER_LIMIT);

        private BufferedAuditBroker(AuditBroker dispatchingAuditBroker) {
            this.dispatchingAuditBroker = dispatchingAuditBroker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<AuditEntity> disableAndGetBuffer() {
            Object object = this.bufferLock;
            synchronized (object) {
                ArrayList<AuditEntity> auditEntities = new ArrayList<AuditEntity>(this.buffer);
                this.buffer = null;
                return auditEntities;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void audit(AuditEntity entity) {
            Object object = this.bufferLock;
            synchronized (object) {
                if (this.buffer == null) {
                    this.dispatchingAuditBroker.audit(entity);
                } else if (this.buffer.size() < BUFFER_LIMIT) {
                    this.buffer.add(entity);
                } else {
                    logger.error("Startup buffer is full and the audit entity is going to be discarded. To increase the buffer size please override the system property audit.broker.buffer.limit. Current buffer limit: {}. Discarded entity: {}", (Object)BUFFER_LIMIT, (Object)entity);
                }
            }
        }
    }
}

