package com.atlassian.audit.api;

import com.atlassian.audit.api.util.pagination.PageRequest;
import com.atlassian.audit.entity.AuditEntity;

import javax.annotation.Nonnull;
import java.time.Instant;

import static java.time.temporal.ChronoUnit.MILLIS;
import static java.util.Objects.requireNonNull;

/**
 * Represents the cursor to be used in {@link PageRequest} for fetching {@link AuditEntity}.
 *
 * @see PageRequest#getCursor()
 * @see AuditSearchService#findBy(AuditQuery, PageRequest)
 */
public class AuditEntityCursor {

    private final Instant timestamp;
    private final long id;

    public AuditEntityCursor(@Nonnull Instant timestamp, long id) {
        this.timestamp = requireNonNull(timestamp, "timestamp");
        this.id = id;
    }

    /**
     * @return the timestamp which represents the {@link AuditEntity#getTimestamp() time} to be considered while
     * fetching {@link AuditEntity}
     */
    @Nonnull
    public Instant getTimestamp() {
        return timestamp.truncatedTo(MILLIS);
    }

    /**
     * @return the unique ID of underlying record in persistency layer that represents {@link AuditEntity}
     */
    public long getId() {
        return id;
    }
}
