package com.atlassian.audit.entity;

import javax.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;

public class AuditCoverageConfig {

    @Nonnull
    private final Map<CoverageArea, EffectiveCoverageLevel> levelByArea;

    public AuditCoverageConfig(@Nonnull Map<CoverageArea, EffectiveCoverageLevel> levelByArea) {
        this.levelByArea = levelByArea;
    }

    @Nonnull
    public Map<CoverageArea, EffectiveCoverageLevel> getLevelByArea() {
        return levelByArea;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuditCoverageConfig that = (AuditCoverageConfig) o;
        return levelByArea.equals(that.levelByArea);
    }

    @Override
    public int hashCode() {
        return Objects.hash(levelByArea);
    }
}
