package com.atlassian.audit.api;

import javax.annotation.Nonnull;
import java.time.Period;

import static java.util.Objects.requireNonNull;

public class AuditRetentionConfig {

    public static final Period DEFAULT_RETENTION_PERIOD = Period.ofYears(3);

    private final Period period;

    public AuditRetentionConfig(@Nonnull Period period) {
        this.period = requireNonNull(period, "period");
    }

    @Nonnull
    public Period getPeriod() {
        return period;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuditRetentionConfig that = (AuditRetentionConfig) o;
        return period.equals(that.period);
    }

    @Override
    public int hashCode() {
        return period.hashCode();
    }
}
