/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.audit.entity;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ExperimentalApi
public final class AuditEntity {
    private static final String version = "1.0";
    private final Instant timestamp;
    private final AuditAuthor author;
    private final AuditType auditType;
    private final Iterable<AuditResource> affectedObjects;
    private final Iterable<ChangedValue> changedValues;
    private final String source;
    private final String system;
    private final String node;
    private final String method;
    private final Iterable<AuditAttribute> extraAttributes;

    private AuditEntity(Builder builder) {
        this.timestamp = builder.timestamp;
        this.author = builder.author;
        this.auditType = builder.type;
        this.affectedObjects = Collections.unmodifiableList(builder.affectedObjects);
        this.changedValues = Collections.unmodifiableList(builder.changedValues);
        this.source = builder.source;
        this.system = builder.system;
        this.node = builder.node;
        this.method = builder.method;
        this.extraAttributes = Collections.unmodifiableList(builder.extraAttributes);
    }

    @Nonnull
    public String getVersion() {
        return version;
    }

    @Nonnull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    public AuditAuthor getAuthor() {
        return this.author;
    }

    @Nonnull
    public AuditType getAuditType() {
        return this.auditType;
    }

    @Nonnull
    public Iterable<AuditResource> getAffectedObjects() {
        return this.affectedObjects;
    }

    @Nonnull
    public Iterable<ChangedValue> getChangedValues() {
        return this.changedValues;
    }

    @Nullable
    public String getSource() {
        return this.source;
    }

    @Nullable
    public String getSystem() {
        return this.system;
    }

    @Nullable
    public String getNode() {
        return this.node;
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    @Nonnull
    public Iterable<AuditAttribute> getExtraAttributes() {
        return this.extraAttributes;
    }

    public Optional<String> getExtraAttribute(String name) {
        return StreamSupport.stream(this.extraAttributes.spliterator(), false).filter(a -> a.getName().equals(name)).findFirst().map(AuditAttribute::getValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditEntity that = (AuditEntity)o;
        return this.timestamp.equals(that.timestamp) && this.author.equals(that.author) && Objects.equals(this.auditType, that.auditType) && Objects.equals(this.affectedObjects, that.affectedObjects) && Objects.equals(this.changedValues, that.changedValues) && Objects.equals(this.source, that.source) && Objects.equals(this.system, that.system) && Objects.equals(this.node, that.node) && Objects.equals(this.method, that.method) && Objects.equals(this.extraAttributes, that.extraAttributes);
    }

    public int hashCode() {
        return Objects.hash(version, this.timestamp, this.author, this.auditType, this.source, this.system, this.node, this.method);
    }

    public String toString() {
        return "AuditEntity{version='1.0', timestamp=" + this.timestamp + ", author=" + this.author + ", auditType='" + this.auditType + '\'' + ", affectedObjects=" + this.affectedObjects + ", changedValues=" + this.changedValues + ", source='" + this.source + '\'' + ", system='" + this.system + '\'' + ", node='" + this.node + '\'' + ", method=" + this.method + ", extraAttributes=" + this.extraAttributes + '}';
    }

    public static Builder builder(AuditType type) {
        return new Builder(type);
    }

    public static final class Builder {
        private Instant timestamp;
        private AuditAuthor author;
        private AuditType type;
        private List<AuditResource> affectedObjects = new ArrayList<AuditResource>();
        private List<ChangedValue> changedValues = new ArrayList<ChangedValue>();
        private String source;
        private String system;
        private String node;
        private String method;
        private List<AuditAttribute> extraAttributes = new ArrayList<AuditAttribute>();

        public Builder(AuditType type) {
            Objects.requireNonNull(type);
            this.type = type;
        }

        public Builder(AuditEntity entity) {
            this.timestamp = entity.timestamp;
            this.author = entity.author;
            this.type = entity.auditType;
            this.affectedObjects = Builder.toList(entity.affectedObjects);
            this.changedValues = Builder.toList(entity.changedValues);
            this.source = entity.source;
            this.system = entity.system;
            this.node = entity.node;
            this.method = entity.method;
            this.extraAttributes = Builder.toList(entity.extraAttributes);
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder author(AuditAuthor author) {
            this.author = author;
            return this;
        }

        public Builder type(AuditType type) {
            this.type = type;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder system(String system) {
            this.system = system;
            return this;
        }

        public Builder node(String node) {
            this.node = node;
            return this;
        }

        public Builder affectedObjects(@Nonnull Iterable<AuditResource> affectedObjects) {
            this.affectedObjects = Builder.toList(Objects.requireNonNull(affectedObjects));
            return this;
        }

        public Builder affectedObject(AuditResource affectedObject) {
            this.affectedObjects.add(affectedObject);
            return this;
        }

        public Builder changedValues(@Nonnull Iterable<ChangedValue> changedValues) {
            this.changedValues = Builder.toList(Objects.requireNonNull(changedValues));
            return this;
        }

        public Builder changedValue(ChangedValue changedValue) {
            this.changedValues.add(changedValue);
            return this;
        }

        public Builder addChangedValueIfDifferent(ChangedValue changedValue) {
            if (!Objects.equals(changedValue.getFrom(), changedValue.getTo())) {
                this.changedValue(changedValue);
            }
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder extraAttributes(@Nonnull Iterable<AuditAttribute> extraAttributes) {
            this.extraAttributes = Builder.toList(Objects.requireNonNull(extraAttributes));
            return this;
        }

        public Builder extraAttribute(AuditAttribute extraAttribute) {
            this.extraAttributes.add(extraAttribute);
            return this;
        }

        public AuditEntity build() {
            if (this.timestamp == null) {
                this.timestamp = Instant.now();
            }
            if (this.author == null) {
                this.author = AuditAuthor.SYSTEM_AUTHOR;
            }
            return new AuditEntity(this);
        }

        private static <T> List<T> toList(Iterable<T> iterable) {
            return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
        }
    }
}

