package com.atlassian.logging.log4j.juli;

import org.apache.logging.log4j.LogManager;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

/**
 * This simple JULI handler will take Java logging calls and re-log them as log4j calls.  This is useful in Tomcat say
 * where you can use this handler to be the JULI handler that Tomcat calls but the output goes to the log4j logs
 * instead.
 */
@SuppressWarnings("UnusedDeclaration")
public class JuliToLog4jHandler extends Handler {
    private JuliToLog4jMapper mapper;

    /**
     * JULI requires no arg constructors and uses setter pattern for configuration
     */
    public JuliToLog4jHandler() {
        this.mapper = new JuliToLog4jMapper();
    }

    /**
     * Can be configured via setter pattern in logging.properties
     *
     * @param mapper the mapper to use
     */
    @SuppressWarnings("UnusedDeclaration")
    public void setMapper(final JuliToLog4jMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(final LogRecord record) {
        JuliToLog4jMapper.MappedLogRecord mapped = mapper.map(record);
        LogManager.getLogger(mapped.getLoggerName()).log(
                mapped.getLevel(),
                mapped.getMessage(),
                mapped.getThrowable());
    }


}
