package com.atlassian.logging.log4j.layout.json;

public class JsonStaticData {
    private final String productName;
    private final long processId;
    private final String serviceId;
    private final String environment;
    private final String dataCenter;
    private final String rack;

    private JsonStaticData(final Builder builder) {
        productName = builder.productName;
        processId = builder.processId;
        serviceId = builder.serviceId;
        environment = builder.environment;
        dataCenter = builder.dataCenter;
        rack = builder.rack;
    }

    public String getProductName() {
        return productName;
    }

    public long getProcessId() {
        return processId;
    }

    public String getServiceId() {
        return serviceId;
    }

    public String getEnvironment() {
        return environment;
    }

    public String getDataCenter() {
        return dataCenter;
    }

    public String getRack() {
        return rack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String productName;
        private long processId;
        private String serviceId;
        private String environment;
        private String dataCenter;
        private String rack;
        private String node;

        public Builder setProductName(final String productName) {
            this.productName = productName;
            return this;
        }

        public Builder setProcessId(final long processId) {
            this.processId = processId;
            return this;
        }

        public Builder setServiceId(final String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder setEnvironment(final String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setDataCenter(final String dataCenter) {
            this.dataCenter = dataCenter;
            return this;
        }

        public Builder setRack(final String rack) {
            this.rack = rack;
            return this;
        }

        public Builder setNode(final String node) {
            this.node = node;
            return this;
        }

        public JsonStaticData build() {
            return new JsonStaticData(this);
        }
    }
}
