/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j.juli;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class JuliToLog4jMapper {
    private static Map<Level, org.apache.log4j.Level> levelMap = new HashMap<Level, org.apache.log4j.Level>();
    private final SimpleFormatter formatter = new SimpleFormatter();

    public MappedLogRecord map(LogRecord lr) {
        return new MappedLogRecord(this.mapCalledFQCN(lr), this.mapLoggerName(lr), this.mapLevel(lr), this.mapMessage(lr), this.mapThrowable(lr));
    }

    protected org.apache.log4j.Level mapLevel(@Nonnull LogRecord lr) {
        org.apache.log4j.Level lvl = levelMap.get(lr.getLevel());
        return lvl == null ? org.apache.log4j.Level.ERROR : lvl;
    }

    protected String mapMessage(@Nonnull LogRecord lr) {
        return this.formatter.formatMessage(lr);
    }

    protected String mapLoggerName(@Nonnull LogRecord lr) {
        return lr.getLoggerName();
    }

    protected String mapCalledFQCN(@Nonnull LogRecord lr) {
        return StringUtils.defaultString((String)lr.getSourceClassName());
    }

    protected Throwable mapThrowable(@Nonnull LogRecord lr) {
        return lr.getThrown();
    }

    static {
        levelMap.put(Level.ALL, org.apache.log4j.Level.ALL);
        levelMap.put(Level.FINEST, org.apache.log4j.Level.TRACE);
        levelMap.put(Level.FINER, org.apache.log4j.Level.DEBUG);
        levelMap.put(Level.FINE, org.apache.log4j.Level.DEBUG);
        levelMap.put(Level.INFO, org.apache.log4j.Level.INFO);
        levelMap.put(Level.CONFIG, org.apache.log4j.Level.INFO);
        levelMap.put(Level.WARNING, org.apache.log4j.Level.WARN);
        levelMap.put(Level.SEVERE, org.apache.log4j.Level.ERROR);
        levelMap.put(Level.OFF, org.apache.log4j.Level.OFF);
    }

    public static class MappedLogRecord {
        private final String callerFQCN;
        private final String loggerName;
        private final org.apache.log4j.Level level;
        private final String message;
        private final Throwable throwable;

        public MappedLogRecord(String callerFQCN, String loggerName, org.apache.log4j.Level level, String message, Throwable throwable) {
            this.callerFQCN = callerFQCN;
            this.loggerName = loggerName;
            this.level = level;
            this.message = message;
            this.throwable = throwable;
        }

        public String getCallerFQCN() {
            return this.callerFQCN;
        }

        public org.apache.log4j.Level getLevel() {
            return this.level;
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

