/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j;

import com.atlassian.logging.log4j.FqNameCollapser;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class CategoryCollapsingPatternParser
extends PatternParser {
    private final int fqNameCollapsePrecision;
    private FqNameCollapser fqNameCollapser;

    public CategoryCollapsingPatternParser(String pattern, int fqNameCollapsePrecision) {
        super(pattern);
        this.fqNameCollapsePrecision = fqNameCollapsePrecision;
        this.fqNameCollapser = new FqNameCollapser(fqNameCollapsePrecision, FqNameCollapser.Strategy.PACKAGE_SEGMENTS);
    }

    protected void finalizeConverter(char character) {
        switch (character) {
            case 'Q': {
                this.fqNameCollapser = new FqNameCollapser(this.extractPrecisionOption(), FqNameCollapser.Strategy.PACKAGE_LENGTH);
                this.addConverter(new CategoryCollapsingPatternConverter(this.formattingInfo, this.fqNameCollapser));
                break;
            }
            case 'q': {
                this.fqNameCollapser = new FqNameCollapser(this.extractPrecisionOption(), FqNameCollapser.Strategy.PACKAGE_SEGMENTS);
                this.addConverter(new CategoryCollapsingPatternConverter(this.formattingInfo, this.fqNameCollapser));
                break;
            }
            default: {
                super.finalizeConverter(character);
            }
        }
    }

    protected int extractPrecisionOption() {
        String opt = this.extractOption();
        if (StringUtils.isBlank((CharSequence)opt)) {
            return this.fqNameCollapsePrecision;
        }
        try {
            return Integer.parseInt(opt);
        }
        catch (NumberFormatException e) {
            return this.fqNameCollapsePrecision;
        }
    }

    protected static class CategoryCollapsingPatternConverter
    extends PatternConverter {
        private final FqNameCollapser collapser;

        CategoryCollapsingPatternConverter(FormattingInfo info, FqNameCollapser fqNameCollapser) {
            super(info);
            this.collapser = fqNameCollapser;
        }

        public String convert(LoggingEvent event) {
            return this.collapser.collapse(event.getLoggerName());
        }
    }
}

