/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j.appender.fluentd;

import com.atlassian.logging.log4j.LogMessageUtil;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.spi.LoggingEvent;

@ThreadSafe
public class LoggingEventQueue {
    private final long maxNumChars;
    volatile LinkedList<LoggingEvent> loggingEventQueue = new LinkedList();
    private volatile int logSize = 0;

    public LoggingEventQueue(long maxNumChars) {
        this.maxNumChars = maxNumChars;
    }

    public synchronized void enqueue(LoggingEvent loggingEvent) {
        this.loggingEventQueue.add(loggingEvent);
        this.logSize += LogMessageUtil.getSize(loggingEvent);
        while ((long)this.logSize > this.maxNumChars) {
            this.dequeue();
        }
    }

    public synchronized List<LoggingEvent> retrieveLoggingEvents(int maximum) {
        LinkedList<LoggingEvent> events = new LinkedList<LoggingEvent>();
        if (maximum < 0 || maximum >= this.loggingEventQueue.size()) {
            LinkedList<LoggingEvent> currentQueue = this.loggingEventQueue;
            this.loggingEventQueue = new LinkedList();
            this.logSize = 0;
            return currentQueue;
        }
        for (int remaining = maximum; remaining > 0; --remaining) {
            events.add(this.dequeue());
        }
        return events;
    }

    public synchronized LoggingEvent dequeue() {
        LoggingEvent event = this.loggingEventQueue.poll();
        if (event != null) {
            this.logSize -= LogMessageUtil.getSize(event);
        }
        return event;
    }

    public int getSize() {
        return this.logSize;
    }

    public boolean isFull() {
        return (long)this.getSize() >= this.maxNumChars;
    }
}

