/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j.appender.fluentd;

import com.atlassian.logging.log4j.appender.fluentd.FluentdRetryableException;
import com.atlassian.logging.log4j.appender.fluentd.FluentdSender;
import com.atlassian.logging.log4j.appender.fluentd.LoggingEventQueue;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import java.util.List;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class FluentdLogQueueSendTask
extends TimerTask {
    private static final int FLUENTD_BATCH_SIZE = 50;
    private final Layout layout;
    private final LoggingEventQueue loggingEventQueue;
    private final int maxRetryPeriodMs;
    private final int backoffMultiplier;
    private final int maxBackoffMinutes;
    private final Retryer<Void> sendoffRetryer;
    private final FluentdSender fluentdSender;

    public FluentdLogQueueSendTask(Layout layout, LoggingEventQueue loggingEventQueue, FluentdSender fluentdSender, int maxRetryPeriodMs, int backoffMultiplier, int maxBackoffMinutes) {
        this.layout = layout;
        this.loggingEventQueue = loggingEventQueue;
        this.fluentdSender = fluentdSender;
        this.maxRetryPeriodMs = maxRetryPeriodMs;
        this.backoffMultiplier = backoffMultiplier;
        this.maxBackoffMinutes = maxBackoffMinutes;
        this.sendoffRetryer = this.buildRetryer();
    }

    private Retryer<Void> buildRetryer() {
        StopStrategy stopStrategy = new StopStrategy(){
            private final StopStrategy stopAfterDelay;
            {
                this.stopAfterDelay = StopStrategies.stopAfterDelay((long)FluentdLogQueueSendTask.this.maxRetryPeriodMs);
            }

            public boolean shouldStop(int previousAttemptNumber, long delaySinceFirstAttemptInMillis) {
                if (this.stopAfterDelay.shouldStop(previousAttemptNumber, delaySinceFirstAttemptInMillis)) {
                    return true;
                }
                return FluentdLogQueueSendTask.this.loggingEventQueue.isFull();
            }
        };
        WaitStrategy waitStrategy = new WaitStrategy(){
            public static final double RANDOM_RANGE_PERCENT = 1.2;
            private final Random RANDOM = new Random();
            private WaitStrategy exponentialWait = WaitStrategies.exponentialWait((long)FluentdLogQueueSendTask.access$200(FluentdLogQueueSendTask.this), (long)FluentdLogQueueSendTask.access$300(FluentdLogQueueSendTask.this), (TimeUnit)TimeUnit.MINUTES);

            public long computeSleepTime(int previousAttemptNumber, long delaySinceFirstAttemptInMillis) {
                long minimum = this.exponentialWait.computeSleepTime(previousAttemptNumber, delaySinceFirstAttemptInMillis);
                long maximum = (long)((double)minimum * 1.2);
                return minimum + Math.abs(this.RANDOM.nextLong()) % (maximum - minimum);
            }
        };
        return RetryerBuilder.newBuilder().retryIfExceptionOfType(FluentdRetryableException.class).retryIfRuntimeException().withWaitStrategy(waitStrategy).withStopStrategy(stopStrategy).build();
    }

    @Override
    public void run() {
        List<LoggingEvent> eventsToSend = this.loggingEventQueue.retrieveLoggingEvents(50);
        if (eventsToSend.isEmpty()) {
            return;
        }
        try {
            final String payload = this.buildPayload(eventsToSend);
            this.sendoffRetryer.call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws FluentdRetryableException {
                    try {
                        FluentdLogQueueSendTask.this.fluentdSender.send(payload);
                    }
                    catch (Exception e) {
                        LogLog.debug((String)"Error in attempt to send logs to FluentD", (Throwable)e);
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (RetryException e) {
            LogLog.debug((String)("FluentD logging failed - " + eventsToSend.size() + " logs lost"), (Throwable)e);
        }
        catch (ExecutionException e) {
            LogLog.debug((String)"FluentD logging failed for unknown reason", (Throwable)e);
        }
    }

    private String buildPayload(List<LoggingEvent> loggingEvents) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int i = 1;
        for (LoggingEvent event : loggingEvents) {
            stringBuilder.append(this.layout.format(event));
            if (i != loggingEvents.size()) {
                stringBuilder.append(",");
            }
            ++i;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static /* synthetic */ int access$200(FluentdLogQueueSendTask x0) {
        return x0.backoffMultiplier;
    }

    static /* synthetic */ int access$300(FluentdLogQueueSendTask x0) {
        return x0.maxBackoffMinutes;
    }
}

