package com.atlassian.logging.log4j;

/**
 * A helper of system aware new line-ness.  This is a helper to do all things newline that is system independent.
 */
public class NewLineSupport
{
    /**
     * System provided NL
     */
    public static String NL;

    static
    {
        try
        {
            NL = System.getProperty("line.separator");
        }
        catch (SecurityException ignore)
        {
            NL = "\n";
        }
    }

    /**
     * Joins together a series of lines into a buffer using the system new line character
     *
     * @param buffer the place to write the lines with new line
     * @param lines the source lines
     * @return the buffer passed in once changed
     */
    public static StringBuffer join(StringBuffer buffer, String[] lines)
    {
        for (String line : lines)
        {
            buffer.append(line).append(NL);
        }
        return buffer;
    }

    /**
     * Joins together a series of lines into a buffer using the system new line character
     *
     * @param buffer the place to write the lines with new line
     * @param lines the source lines
     * @return the buffer passed in once changed
     */
    public static StringBuilder join(StringBuilder buffer, String[] lines)
    {
        for (String line : lines)
        {
            buffer.append(line).append(NL);
        }
        return buffer;
    }

    /**
     * Joins together a series of lines into a String using the system new line character
     *
     * @param lines the source lines
     * @return the the joined lines as a single String
     */
    public static String join(String[] lines)
    {
        return join(new StringBuilder(), lines).toString();
    }

}
